package attivita_atomiche;

import java.util.*;

import partita.*;
import soldato.*;
import partecipa.*;

import _framework.Executor;
import _framework.Task;


public class AttendiTerminePartita implements Task {

	private boolean eseguita = false;
	private Partita partita;
	private boolean risultato = false;

	public AttendiTerminePartita(Partita partita) {
		this.partita = partita;
	}

	public synchronized void esegui(Executor e) {

		if (e == null || eseguita == true)
			return;
		eseguita = true;
		risultato = true;
		List<TipoLinkPartecipa> soldati = partita.getLinkPartecipa();
		for(int i = 0; i < soldati.size() && risultato; i++){
			Soldato prossimo = soldati.get(i).getSoldato();
			risultato = (prossimo.getStato() == Soldato.Stato.FINITA) || (prossimo.getStato() == Soldato.Stato.SCOPERTO);
		}
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
	
	public synchronized boolean getRisultato(){
		if (!estEseguita()){
			throw new RuntimeException("RIsultato non pronto");
		}
		return risultato;
	}
	
}

