package gui;

import java.awt.*;
import java.util.*;

import ciclisti.*;
import ciclisti.ciclista.*;
import ciclisti.partecipa.TipoLinkPartecipa;

import it.uniroma1.dis.grafica.*;

class Percorso extends DrawPanel{// non pubblica perch ad uso interno del package
	private final int LARGHEZZA = 800; // larghezza in pixel del percorso
	private final int ALTEZZA = 40; // altezza di ciascuna corsia in pixel
	private final int SPESSORE_LINEA = 3;
	private final int MARGINE = 10;
	private final int MARGINE_NOMI= 100;
	private final String SEGNALINO = "O";

	private HashMap<Ciclista,Text> posizione; // per memorizzare la posizione dei ciclisti lungo il percorso
	private int altezzaTotale = 0;
	private Gara gara;
	
	public Percorso(Gara gara){
		this.gara = gara;
		posizione = new HashMap<Ciclista,Text>();
		Set<TipoLinkPartecipa> linkPartecipanti = null;
		try{
			linkPartecipanti = gara.getLinkPartecipa();
		}
		catch(EccezioneMoltMinMax e){
			e.printStackTrace();
			System.exit(1);
		}
		// Inizializza la mappa ed i segnalini dei ciclisti
		Iterator<TipoLinkPartecipa> it = linkPartecipanti.iterator();
		int i = 1;
		while(it.hasNext()){
			Ciclista ciclistaCorrente = it.next().getCiclista();
			addFigureBatch(new Text(ciclistaCorrente.getNome(),new Point(MARGINE,MARGINE+SPESSORE_LINEA+ALTEZZA*i-ALTEZZA/2)));
			Text segnalinoCiclistaCorrente = new Text(SEGNALINO,new Point(MARGINE + SPESSORE_LINEA + MARGINE_NOMI,MARGINE+SPESSORE_LINEA+ALTEZZA*i-ALTEZZA/2)); 
			addFigureBatch(segnalinoCiclistaCorrente);
			posizione.put(ciclistaCorrente, segnalinoCiclistaCorrente);
			i++;		
		}
		
		// disegna la pista
		
		altezzaTotale = linkPartecipanti.size() * ALTEZZA;
		
		// linee laterali
		Point start = new Point(MARGINE+MARGINE_NOMI,MARGINE);
		Point end = new Point(MARGINE+MARGINE_NOMI,MARGINE+altezzaTotale);
		Line l=new Line(start, end);
		l.setLineSize(SPESSORE_LINEA);
		addFigureBatch(l);
		
		start = new Point(MARGINE+MARGINE_NOMI+LARGHEZZA,MARGINE);
		end = new Point(MARGINE+MARGINE_NOMI+LARGHEZZA,MARGINE+altezzaTotale);
		l=new Line(start, end);
		l.setLineSize(SPESSORE_LINEA);
		addFigureBatch(l);
		
		start = new Point(3*MARGINE+MARGINE_NOMI+LARGHEZZA,MARGINE);
		end = new Point(3*MARGINE+MARGINE_NOMI+LARGHEZZA,MARGINE+altezzaTotale);
		l=new Line(start, end);
		l.setLineSize(SPESSORE_LINEA);
		addFigureBatch(l);
		
		// corsie
		for (i = 0; i <= linkPartecipanti.size(); i++){
			start = new Point(MARGINE,MARGINE+ALTEZZA * i);
			end = new Point(3*MARGINE+LARGHEZZA+MARGINE_NOMI, MARGINE+ALTEZZA * i);
			l=new Line(start, end);
			l.setLineSize(SPESSORE_LINEA);
			addFigureBatch(l);
		}

		commit();
	}
	
	public void setPosizioneCiclista(Ciclista ciclista){
		TipoLinkPartecipa l = ciclista.getLinkPartecipa();
		if (l == null || l.getGara() != gara){
			// se il ciclista non e' iscritto alla gara o la gara non e' quella corrente, non fa niente
			return;
		}
		// Il ciclista e' iscritto alla gara cui la finestra fa riferimento

		//Normalizza la posizione in base alla dimensione del percorso
		int nuovaPosizioneCiclista = (int)((l.getKmPercorsi() / gara.getDistanza()) * LARGHEZZA);
		if (nuovaPosizioneCiclista >= LARGHEZZA){// arrivato al traguardo
			nuovaPosizioneCiclista = LARGHEZZA;
		}
		// Posiziona il Segnalino in base alla nuova posizione (l'altezza e' la stessa del segnalino precedente)
		Text segnalinoCiclista = new Text(SEGNALINO,
				new Point(MARGINE + SPESSORE_LINEA + MARGINE_NOMI + nuovaPosizioneCiclista,
							posizione.get(ciclista).getPoint().y)); 
		removeFigure(posizione.get(ciclista));// toglie il ciclista dalla posizione corrente...
		addFigureBatch(segnalinoCiclista);//... lo rimpiazza con quella nuova
		posizione.put(ciclista, segnalinoCiclista); // aggiorna la mappa
		commit();
	}
	
	
	@Override
	public Dimension getPreferredSize(){
		return(new Dimension(LARGHEZZA+MARGINE_NOMI+5*MARGINE,altezzaTotale+MARGINE_NOMI+MARGINE));
	}
}






