package ciclisti.ciclista;

import _framework.*;
import _gestioneeventi.*;
import ciclisti.*;
import ciclisti.partecipa.*;

public class Ciclista implements Listener{
	private final String nome;
	
	private TipoLinkPartecipa partecipa;
	
	public Ciclista(String nome) {
		this.nome = nome;
		partecipa = null;
	}

	public String getNome() {
		return nome;
	}
	
	public void inserisciLinkPartecipa(TipoLinkPartecipa l){	
		if (l != null && l.getCiclista() == this){
			ManagerPartecipa.inserisci(l);
		}
	}

	public void inserisciPerManagerPartecipa(ManagerPartecipa m){
		if (m != null){
			partecipa = m.getLink();
		}
	}

	public void eliminaLinkPartecipa(TipoLinkPartecipa l){	
		if (l != null && l.getCiclista() == this){
			ManagerPartecipa.elimina(l);
		}
	}

	public void eliminaPerManagerPartecipa(ManagerPartecipa m){
		if (m != null){
			partecipa = null;
		}
	}

	@SuppressWarnings("unchecked")
	public TipoLinkPartecipa getLinkPartecipa(){
		return partecipa;
	}
	
	public int quantiPartecipa(){
		if (partecipa != null){
			return 1;
		}
		return 0;
	}
	
	// gestione stato

	public static enum Stato {
		PRONTO, IN_GARA, IN_TESTA, FINITO
	}

	Stato statoCorrente = Stato.PRONTO;

	public Stato getStato() {
		return statoCorrente;
	}

	public void fired(Evento e) {
		Executor.perform(new CiclistaFired(this, e));
	}
}







