package ciclisti;

import java.util.*;

import ciclisti.ciclista.*;
import ciclisti.partecipa.*;

public class Gara {
	private final String nome;
	private final float distanza;
	private HashSet<Ciclista> vincitori;
	
	private HashSet<TipoLinkPartecipa> partecipa;
	
	public final int MINPARTECIPA = 2;

	public Gara(String nome, float distanza) {
		this.nome = nome;
		this.distanza = distanza;
		partecipa = new HashSet<TipoLinkPartecipa>();
		vincitori = new HashSet<Ciclista>();
	}

	public String getNome() {
		return nome;
	}
	
	public float getDistanza() {
		return distanza;
	}
	
	public void inserisciLinkPartecipa(TipoLinkPartecipa l){
		if (l != null && l.getGara() == this){
			ManagerPartecipa.inserisci(l);
		}
	}

	public synchronized void inserisciPerManagerPartecipa(ManagerPartecipa m){
		if (m != null){
			partecipa.add(m.getLink());
		}
	}

	public void eliminaLinkPartecipa(TipoLinkPartecipa l){	
		if (l != null && l.getGara() == this){
			ManagerPartecipa.elimina(l);
		}
	}

	public void eliminaPerManagerPartecipa(ManagerPartecipa m){
		if (m != null){
			partecipa.remove(m.getLink());
		}
	}

	@SuppressWarnings("unchecked")
	public synchronized Set<TipoLinkPartecipa> getLinkPartecipa() throws EccezioneMoltMinMax{
		if (quantiCiclisti() < MINPARTECIPA)
			throw new EccezioneMoltMinMax("Eccezione Molteplicita' minima");
		return (HashSet<TipoLinkPartecipa>) partecipa.clone();
	}

	public int quantiCiclisti() {
		return partecipa.size();
	}
	
	public void inserisciLinkVincitore(Ciclista c){
		if (c != null){
			vincitori.add(c);
		}
	}
	
	public void eliminaLinkVincitore(Ciclista c){
		if (c != null){
			vincitori.remove(c);
		}
	}
	
	public Set<Ciclista> getLinkVincitori() throws EccezioneMoltMinMax, EccezioneSubset{
		if(quantiVincitori() < 1){
			throw new EccezioneMoltMinMax("Eccezione Molteplicita' minima");
		}
		// Verifica del vincolo di Subset
		Iterator<Ciclista> it = vincitori.iterator();
		while(it.hasNext()){
			try{
				if (!partecipa.contains(new TipoLinkPartecipa(this,it.next(),0))){
					throw new EccezioneSubset("Vincolo di subset violato");
				}
			}
			catch(EccezionePrecondizioni eccezione){
				eccezione.printStackTrace();
				System.exit(1);
			}
		}
		// Restituisce i vincitori
		return (HashSet<Ciclista>) vincitori.clone();
	}
	
	public int quantiVincitori(){
		return vincitori.size();
	}
}





