package attivita_atomiche;

import java.util.*;

import javax.swing.JOptionPane;

import gui.*;
import ciclisti.*;
import ciclisti.ciclista.*;
import ciclisti.partecipa.TipoLinkPartecipa;

public class AttivitaIO {
	private static FinestraPercorso finestraPercorso = null;
	
	public static Gara inserisciDatiGara() 
	{
		InserisciDatiGara frame=new InserisciDatiGara();
		frame.aspettaOK();
		try
		{
			return new Gara(frame.leggiNome(),Float.parseFloat(frame.leggiDistanza()));
		}
		catch(NumberFormatException err)
		{
			return inserisciDatiGara();
		}
	}

	public static Ciclista inserisciDatiCiclista()
	{	
		String nome;
		do
		{
			nome=JOptionPane.showInputDialog(null, "Specificare il nome del ciclista:","Iscrizione Ciclista", 
					JOptionPane.PLAIN_MESSAGE);
		} while(nome==null);
		
		return(new Ciclista(nome));
	}

	public static boolean chiediSeAltroCiclista() {
		int yn=JOptionPane.showConfirmDialog(null, "Si vuole iscrivere un altro ciclista alla gara", "Iscrizione Ciclista"
				, JOptionPane.YES_NO_OPTION);
		return(yn==JOptionPane.YES_OPTION);
	}

	public static void proclamaVincitori(Gara gara) 
	{
		Set<Ciclista> vincitori=null;
		Set<TipoLinkPartecipa> partecipanti=null;
		try 
		{
			vincitori=gara.getLinkVincitori();
			partecipanti=gara.getLinkPartecipa();
			new ProclamaVincitoriFrame(vincitori,partecipanti);
		} 
		catch (EccezioneMoltMinMax e) 
		{
			e.printStackTrace();
			System.exit(1);
		} catch (EccezioneSubset e) {
			e.printStackTrace();
			System.exit(1);
		}
		
	}

		
	public static void visualizzaGara(Gara gara){
		finestraPercorso = new FinestraPercorso(gara);
		Thread aggiornatore = new Thread(new Aggiorna(gara,finestraPercorso,50));
		aggiornatore.start();
	}
	
}

class Aggiorna implements Runnable{// non public perche' interno al package
	// Necessario per il refresh del Percorso
	// Ogni msec millisecondi aggiorna la finestra
	private Gara gara;
	private FinestraPercorso finestra;
	private int msec;
	
	public Aggiorna(Gara gara, FinestraPercorso finestra, int msec){
		this.gara = gara;
		this.finestra = finestra;
		this.msec = msec;
	}
	
	public void run(){
		while(true){
			try{
				Thread.sleep(msec);
			}
			catch(InterruptedException e){
				e.printStackTrace();
				System.exit(1);
			}
				finestra.aggiorna(gara);
		}
	}
}





