package attivita_atomiche;

import java.util.*;

import ciclisti.*;
import ciclisti.ciclista.*;
import ciclisti.partecipa.*;
import _framework.*;

public class AggiornaVincitori implements Task {
	private boolean eseguita = false;
	private Gara gara;

	public AggiornaVincitori(Gara gara) {
		this.gara = gara;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;
		
		Iterator<TipoLinkPartecipa> it = null;
		try{
			it = gara.getLinkPartecipa().iterator();
		}
		catch(EccezioneMoltMinMax eccezione){
			eccezione.printStackTrace();
			System.exit(1);
		}
		
		float massimoCorrente = 0;
		Set<Ciclista> vincitoriCorrenti = new HashSet<Ciclista>();
		
		while (it.hasNext()) {
			TipoLinkPartecipa linkCorrente = it.next();
			if (linkCorrente.getKmPercorsi() > massimoCorrente){// trovato un ciclista migliore dei precedenti
				// svuota l'insieme corrente dei vincitori
				vincitoriCorrenti.clear();
				// Aggiorna il massimo corrente
				massimoCorrente = linkCorrente.getKmPercorsi();
			}
			if (linkCorrente.getKmPercorsi() >= massimoCorrente){			
				// inserisci il ciclista corrente
				// NOTA: Se > l'insieme vincitoriCorrenti e' stato svuotato
				vincitoriCorrenti.add(linkCorrente.getCiclista());
			}	
		}
		// Aggiorna i vincitori della gara
		Iterator<Ciclista> itc = vincitoriCorrenti.iterator();
		
		while(itc.hasNext()){
			gara.inserisciLinkVincitore(itc.next());
		}		
	}
	
	public synchronized boolean estEseguita() {
		return eseguita;
	}

}
