package gui;

import javax.swing.*;

import ciclisti.*;
import ciclisti.ciclista.*;
import ciclisti.partecipa.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import _gestioneeventi.*;

public class FinestraPercorso extends JFrame {
	// private final JPanel southPanel = new JPanel();
	private final Container frmContentPane;
	
	private Percorso percorso;
	private Gara gara;
	
	public FinestraPercorso(Gara gara){
		super(gara.getNome());
		this.gara = gara;
		frmContentPane = getContentPane();
		prepara();
		setVisible(true);
	}
	
	public synchronized void prepara(){// prepara la finestra per la visualizzazione
		frmContentPane.setLayout(new BorderLayout());
		percorso = new Percorso(gara);
		frmContentPane.add(percorso, BorderLayout.NORTH);		
		//frmContentPane.add(southPanel, BorderLayout.SOUTH);	
		this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);		
		pack();
	}
	
	public synchronized void aggiorna(Ciclista c){
			percorso.setPosizioneCiclista(c);
	}
		
	public synchronized void aggiorna(Gara g){
		Set<TipoLinkPartecipa> partecipanti = null;
		try{
			partecipanti = g.getLinkPartecipa();
		}
		catch(EccezioneMoltMinMax e){
			e.printStackTrace();
			System.exit(1);
		}
		Iterator<TipoLinkPartecipa> it = partecipanti.iterator();
		while(it.hasNext()){
			percorso.setPosizioneCiclista(it.next().getCiclista());
		}
	}
}



