package processo;

import java.util.Iterator;
import java.util.List;
import emergenza.*;

import gui.RecordPersona;
import _framework.Executor;
import _framework.Task;

public class AggiornaInfoEdifici implements Task 
{
	private Edificio edif;
	private List<RecordPersona> recQuest;

	public AggiornaInfoEdifici(Edificio edif, List<RecordPersona> recQuest) {
		this.edif=edif;
		this.recQuest=recQuest;
	}

	public void esegui(Executor e) 
	{
		try {
			Iterator<RecordPersona> iter = recQuest.iterator();
			while (iter.hasNext()) {
				RecordPersona recP = iter.next();
				Persona pers;
				if (recP.isVivo()) {
					pers = new PersonaViva(recP.getEta(), recP.getNominativo());
					if (recP.getOspedale()!=null)
					{
						Ospedale osp=recP.getOspedale();

							((PersonaViva)pers).inserisciLink(
									new TipoLinkRicovero(((PersonaViva)pers),osp));
					}
				}
				else
					pers = new PersonaMorta(recP.getEta(), recP.getNominativo());
		
				edif.inserisciLinkCollocazione(new TipoLinkCollocazione(pers,edif));
			}
		} 
		catch (EccezionePrecondizioni e2) 
		{
			e2.printStackTrace();
			System.exit(1);
		}
	}

}
