package gui;

import java.awt.BorderLayout;
import java.awt.event.*;
import java.util.*;

import javax.swing.*;
import javax.swing.table.AbstractTableModel;

import applicazione.Main;

import emergenza.Ospedale;

class AggPersoneListener implements ActionListener
{
	private InfoPersonaFrame frame;
	
	public AggPersoneListener(InfoPersonaFrame frame)
	{
		this.frame=frame;
	}
	
	public void actionPerformed(ActionEvent e)
	{
		String nominativo=JOptionPane.showInputDialog(frame,"Inserire il nominativo:");
		if (nominativo==null)
			return;
		String etaStr=JOptionPane.showInputDialog(frame,"Inserire l'et:");
		if (etaStr==null)
			return;	
		int eta;
		try 
		{
			eta = Integer.parseInt(etaStr);
		} 
		catch (NumberFormatException e2) {
			return;
		}
		int yn=JOptionPane.showConfirmDialog(frame, "La persona "+nominativo+ "  viva?");
		boolean vivo=(yn==JOptionPane.YES_OPTION);
		Ospedale ospedale=null;
		if (vivo)
		{
			Ospedale[] arrayOspedale=Main.listaOspedali;
			ospedale=(Ospedale)JOptionPane.showInputDialog(frame,"Specificare l'ospedale in cui deve essere ricoverato\n" +
					"(Oppure premere ANNULLA se non deve essere ricoverato in nessun ospedale)",
					" Ricovero",JOptionPane.INFORMATION_MESSAGE, null,arrayOspedale,arrayOspedale[0]);
		}
		RecordPersona record=new RecordPersona(nominativo,eta,vivo,ospedale);
		frame.aggiungiNuovoRecordPersona(record);
	}
}

class OKPersoneListener implements ActionListener
{
	private InfoPersonaFrame frame;
	
	public OKPersoneListener(InfoPersonaFrame frame)
	{
		this.frame=frame;
	}	
	
	public void actionPerformed(ActionEvent e)
	{
		frame.dispose();
		synchronized(frame)
		{
			frame.notify();
		}
	}
}
	
public class InfoPersonaFrame extends JFrame
{
	class MyTableModel extends AbstractTableModel
	{
		public int getColumnCount() { return (4); }
		public int getRowCount() { return(recAree.size()); }

		public Object getValueAt(int row, int col) { 
			RecordPersona record=recAree.get(row);
			switch(col)
			{
			case 0:
				return(record.getNominativo());
			case 1:
				return(new Integer(record.getEta()));
			case 2:
				String vivo="S";
				if (!record.isVivo())
					vivo="No";
				return(vivo);
			case 3:
				return(record.getOspedale());
			default:
				return("Errore");
			}
		}
		
		public String getColumnName(int col)
		{
			switch(col)
			{
			case 0:
				return("Nominativo");
			case 1:
				return("Et");
			case 2:
				return("Vivo");
			case 3:
				return("Nome ospedale");
			default:
				return("Errore");
			}			
		}
		
	}
	
	private Vector<RecordPersona> recAree=new Vector<RecordPersona>();
	private JButton aggAreaBtn=new JButton("Aggiungi nuova persona");
	private JButton okBtn=new JButton("OK");
	private JLabel areeLbl=new JLabel("Persone nell'edificio:");
	private JPanel centroPnl=new JPanel(new BorderLayout());
	private JPanel sudPnl=new JPanel();
	private JTable tabella=new JTable(new MyTableModel());
	
	void aggiungiNuovoRecordPersona(RecordPersona record)
	{
		recAree.add(record);
		tabella.updateUI();		
	}
	
	public List<RecordPersona> getRecordList()
	{
		return(recAree);
	}
	
	public InfoPersonaFrame(String edificio)
	{
		super("Inserimento persona presenti nell'edificio "+edificio);
		centroPnl.add(areeLbl, BorderLayout.NORTH);
		centroPnl.add(new JScrollPane(tabella),BorderLayout.CENTER);
		sudPnl.add(aggAreaBtn);
		okBtn.addActionListener(new OKPersoneListener(this));
		aggAreaBtn.addActionListener(new AggPersoneListener(this));
		sudPnl.add(okBtn);
		this.getContentPane().add(centroPnl,BorderLayout.CENTER);
		this.getContentPane().add(sudPnl,BorderLayout.SOUTH);
		setSize(300,400);
		setVisible(true);
	}
	
}
