package gui;

import java.util.*;

import javax.swing.JOptionPane;

import emergenza.Area;
import emergenza.Edificio;
import emergenza.Ospedale;
import emergenza.Persona;
import emergenza.PersonaViva;
import emergenza.TipoLinkCollocazione;
import emergenza.TipoLinkContiene;


public class AttivitaIO {

	public static List<Area> inserisciInfoArea() 
	{
		InfoAreaFrame frame=new InfoAreaFrame();
		try 
		{
			synchronized(frame)
			{
				frame.wait();
			}
		} 
		catch (InterruptedException e) {
			e.printStackTrace();
			System.exit(1);
		}
		return frame.getList();
	}

	public static List<Edificio> inserisciEdifici(String nomeArea) 
	{
		InfoEdificiFrame frame=new InfoEdificiFrame(nomeArea);
		try 
		{
			synchronized(frame)
			{
				frame.wait();
			}
		} 
		catch (InterruptedException e) {
			e.printStackTrace();
			System.exit(1);
		}
		LinkedList<Edificio> retValue=new LinkedList<Edificio>();
		for(String indirizzo : frame.getRecordList())
		{
			retValue.add(new Edificio(indirizzo));
		}
		return retValue;
	}

	public static boolean leggiAgibilita(String indirizzo) 
	{
		int yn=JOptionPane.showConfirmDialog(null,"L'edificio all'indirizzo "+indirizzo+
				"  agibile?","Agibilit",JOptionPane.YES_NO_OPTION);
		return(yn==JOptionPane.YES_OPTION);
	}

	public static List<RecordPersona> leggiQuestionario(String indirizzo) {
		InfoPersonaFrame frame=new InfoPersonaFrame(indirizzo);
		try 
		{
			synchronized(frame)
			{
				frame.wait();
			}
		} 
		catch (InterruptedException e) {
			e.printStackTrace();
			System.exit(1);
		}
		return frame.getRecordList();
	}

	public static void mostraInfoSalienti(Area ar) 
	{
		try {
			System.out.println("Area " + ar.getNome() + " (estensione "
					+ ar.getEstensione() + " mq)");
			Iterator<TipoLinkContiene> tl = ar.getLink().iterator();
			while (tl.hasNext()) {
				Edificio e = tl.next().getEdificio();
				System.out.println("**** Edificio all'indirizzo "
						+ e.getIndirizzo());
				if (e instanceof Ospedale)
					System.out.println(" E' UN OSPEDALE");
				System.out.println("Numero di persone ritrovate vive: "+e.numeroPersoneVive()+" (di cui "+e.numeroPersoneFerite()+" ferite)");
				System.out.println("Numero di persone ritrovate morte: "+e.numeroPersoneMorte());
				Iterator<TipoLinkCollocazione> iter = e.getLinkCollocazione().iterator();
				while (iter.hasNext())
				{
					Persona p= iter.next().getPersona();
					System.out.println("        "+p.getNominativo()+ " di anni "+p.getEta());
					System.out.println("VIVO? " +  (p instanceof PersonaViva ? "S":"No"));
					if (p instanceof PersonaViva)
					{
						PersonaViva pV=(PersonaViva)p;
						if(pV.getTipoLinkRecovero()!=null)
							System.out.println("RICOVERATO NELL'OSPEDALE "+pV.getTipoLinkRecovero().getOspedale().getNome());
					}
				}
			}
		} catch (Exception e) 
		{
			e.printStackTrace();
		}
		
	}


}
