package emergenza;

import java.util.*;

public class Area 
{
	private final float estensione;
	private final String nome;
	private final LinkedList<TipoLinkContiene> link=new LinkedList<TipoLinkContiene>();
	
	public Area(String nome, float estensione)
	{
		this.nome=nome;
		this.estensione=estensione;
	}

	public float getEstensione() {
		return estensione;
	}

	public String getNome() {
		return nome;
	}
	
	public void inserisciLinkContiene(TipoLinkContiene t) {
		if (t != null && t.getArea() == this)
			ManagerContiene.inserisci(t);
	}

	public void inserisciLinkPerManagerContiene(ManagerContiene k) 
	{
		if (k!=null && !link.contains(k.getLink()))
		{
			link.add(k.getLink());
		}
	}
	
	@SuppressWarnings("unchecked")
	public List<TipoLinkContiene> getLink()
	{
		return (List<TipoLinkContiene>) link.clone();
		
	}
	
	public String toString()
	{
		return nome;
	}
}
