package souvenir;

public class TipoLinkComprende
{
	private final Souvenir souvenir;
	private final Scontrino scontrino;
	private final int quantita;
	
	public TipoLinkComprende(Souvenir souvenir, Scontrino scontrino, int quantita) throws EccezionePrecondizioni
	{
		if (souvenir==null || scontrino==null)
			throw(new EccezionePrecondizioni("Impossibile passare dei valori nulli"));
		if (quantita<=0)
			throw(new EccezionePrecondizioni("La quantit deve essere un valore positivo"));			
		this.souvenir=souvenir;
		this.scontrino=scontrino;
		this.quantita=quantita;
	}
	
	public Souvenir getSouvenir() {
		return souvenir;
	}
	public Scontrino getScontrino() {
		return scontrino;
	}

	public int hashCode() 
	{
		return souvenir.hashCode()+scontrino.hashCode();
	}
	
	public int getQuantita()
	{
		return quantita;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TipoLinkComprende other = (TipoLinkComprende) obj;
		if (!souvenir.equals(other.souvenir))
			return false;
		if (!scontrino.equals(other.scontrino))
			return false;
		return true;
	}
	
	
}
