package souvenir;

import java.util.*;

public abstract class Souvenir 
{
	private final String localita;
	private final float prezzo;
	private HashSet<TipoLinkComprende> insiemeScontrini=new HashSet<TipoLinkComprende>();
	
	public Souvenir(String localita,float prezzo) throws EccezionePrecondizioni
	{
		this.localita=localita;
		if (prezzo>0)
			this.prezzo = prezzo;
		else
			throw(new EccezionePrecondizioni("Il prezzo deve essere maggiore di 0"));		
	}
	
	public float getPrezzo() {
		return prezzo;
	}

	public String getLocalita() {
		return localita;
	}
	
	public void inserisciLinkComprende(TipoLinkComprende t) {
		if (t != null && t.getSouvenir() == this)
			ManagerComprende.inserisci(t);
	}
	
	public void inserisciLinkPerManagerComprende(ManagerComprende k) 
	{
		if (k!=null)
			insiemeScontrini.add(k.getLink());
	}
	
	public void eliminaLinkComprende(TipoLinkComprende t) {
		if (t != null && t.getSouvenir() == this)
			ManagerComprende.elimina(t);
	}
	
	public void eliminaLinkPerManagerComprende(ManagerComprende k) 
	{
		if (k!=null)
			insiemeScontrini.remove(k.getLink());
	}
	
	
	@SuppressWarnings("unchecked")
	public Set<TipoLinkComprende> getLinkComprende()
	{
		return((Set<TipoLinkComprende>)insiemeScontrini.clone());
	}
	
}
