package attivita_composte;

import souvenir.*;
import java.util.*;
import _framework.*;
import attivita_atomiche.*;
import attivita_io.*;

public class AttivitaSottoramoMagnete implements Runnable {
	private boolean eseguita=false;
	private Scontrino scontrinoCorrente=null;
	private boolean ancoraMagneti=true;
	private Set<String> magnetiLetti;	
	private RecordAcquisto magneteSelezionato;
	
	public AttivitaSottoramoMagnete(Scontrino scontrinoCorrente){
		this.scontrinoCorrente=scontrinoCorrente;
	}
		
	public synchronized void run() {
		if (eseguita)
			return;
		eseguita = true;
		
		while(ancoraMagneti){
			LeggiMagneti leggiMagneti = new LeggiMagneti();
			Executor.perform(leggiMagneti);
			
			magnetiLetti = leggiMagneti.getRisultato();
			
			magneteSelezionato = AttivitaIO.mostraSouvenirPerSelezione(magnetiLetti);
			
			AggiornaScontrino aggiornaScontrino = new AggiornaScontrino(magneteSelezionato, scontrinoCorrente);
			Executor.perform(aggiornaScontrino);
			
			ancoraMagneti = AttivitaIO.altroMagnete();
		}
	}
}
