package attivita_composte;

import souvenir.*;
import _framework.*;
import attivita_atomiche.*;
import attivita_io.*;

public class AttivitaPrincipale implements Runnable {
	private boolean eseguita=false;
	private Scontrino scontrinoCorrente=null;
	private RecordTipoAcquisti tipoAcquisti=null;
	private RecordScontrino recordScontrino=null;
	
	
	public synchronized void run() {
		if (eseguita)
			return;
		eseguita = true;
		// Chiedi tipo souvenir
		tipoAcquisti=AttivitaIO.chiediTipoSouvenir();
		
		CreaNuovoScontrino creaScontrino = new CreaNuovoScontrino();
		Executor.perform(creaScontrino);
		scontrinoCorrente = creaScontrino.getRisultato();
	
		Thread sottoRamoMagnete = null;
		Thread sottoRamoBerretti = null;

		if (tipoAcquisti.isMagneti()){
			//si' magneti
			sottoRamoMagnete = new Thread(new AttivitaSottoramoMagnete(scontrinoCorrente));				
			sottoRamoMagnete.start();
		}
		
		if (tipoAcquisti.isBerretti()){
			//si' berretti
			sottoRamoBerretti = new Thread(new AttivitaSottoramoBerretti(scontrinoCorrente));				
			sottoRamoBerretti.start();
		}
		
		//join
		try{
			if (sottoRamoMagnete != null){
				sottoRamoMagnete.join();
			}
			if (sottoRamoBerretti != null){
				sottoRamoBerretti.join();
			}
		}
		catch (InterruptedException e){
			e.printStackTrace();
			System.exit(1);
		}			
		
		LeggiScontrino leggiScontrino = new LeggiScontrino(scontrinoCorrente);
		Executor.perform(leggiScontrino);
		
		recordScontrino = leggiScontrino.getRisultato();
		
		AttivitaIO.mostraScontrino(recordScontrino);
	}
}
