package souvenir;

public class Berretto extends Souvenir
{
	private final String colore;
	private final int taglia;
	
	public Berretto(String localita, float prezzo, String colore, int taglia) throws EccezionePrecondizioni 
	{
		super(localita, prezzo);
		if (taglia >0){
			this.colore=colore;
			this.taglia=taglia;
		}
		else
			throw(new EccezionePrecondizioni("La taglia deve avere valore positivo"));
	}

	public String getColore() {
		return colore;
	}

	public int getTaglia() {
		return taglia;
	}
		
	public String toString(){
		return "Berretto " + getLocalita() + " ("+colore+","+taglia+"): " + getPrezzo();
	}
}
