package attivita_io;

import java.util.*;

public class RecordScontrino 
{
	//Numero dello scontrino
	private final int numero;
	// Data di emissione dello scontrino
	private final Date emissione;
	// totale spesa
	private final float totale;
	// Insieme di RecordAcquisto (descrizione-quantita'), contenente tutti i souvenir compresi nello scontrino, con le relative quantita'
	private final HashSet<RecordAcquisto> insieme=new HashSet<RecordAcquisto>();

	public RecordScontrino(int numero,Date emissione,float totale)
	{
		this.numero=numero;
		this.emissione=emissione;
		this.totale=totale;
	}
	
	public void addRecord(RecordAcquisto ra)
	{// Aggiunge RecordAcquisto ra 
		insieme.add(ra);
	}
	
	public int getNumero() {
		return numero;
	}

	public Date getEmissione() {
		return emissione;
	}

	@SuppressWarnings("unchecked")
	public Set<RecordAcquisto> getInsiemeRecord() {
		return (Set<RecordAcquisto>)insieme.clone();
	}

	public float getTotale() {
		return totale;
	}
}
