package attivita_io;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.util.*;

import javax.swing.*;

public class SelezionaSouvenir extends JFrame 
{
	private final JComboBox souvenirCbx;
	private final JLabel souvenirLbl=new JLabel("Souvenir:");
	private final JPanel souvenirPnl=new JPanel();
	private final JLabel quantitaLbl=new JLabel("Quantita':");
	private final JTextField quantitaTxt=new JTextField(2);
	private final JButton okBtn = new JButton("OK");
	private final JPanel centroPnl=new JPanel(new GridLayout(2,1));
	private final JPanel quantitaPnl=new JPanel();
	private final JPanel sudPnl=new JPanel();
	
	private boolean selezionato = false; // necesario alla sincronizzazione delle finestre
	
	public SelezionaSouvenir(Collection<String> e)
	{
		super("Seleziona Souvenir");
		souvenirCbx=new JComboBox(new Vector<String>(e));
		souvenirPnl.add(souvenirLbl);
		souvenirPnl.add(souvenirCbx);
		centroPnl.add(souvenirPnl);
		quantitaPnl.add(quantitaLbl);
		quantitaPnl.add(quantitaTxt);
		centroPnl.add(quantitaPnl);
		sudPnl.add(okBtn);
		okBtn.addActionListener(new SelezionaSouvenirListener(this));
		getContentPane().add(centroPnl,BorderLayout.CENTER);
		getContentPane().add(sudPnl,BorderLayout.SOUTH);
		setSize(200,150);
		setVisible(true);
	}
	
	public RecordAcquisto getAcquisto() throws NumberFormatException{
		String descrizione = (String) souvenirCbx.getSelectedItem();
		RecordAcquisto acquisto = new RecordAcquisto(descrizione, Integer.parseInt(quantitaTxt.getText()));		
		return acquisto;
	}
	
	public void setSelezionato(){
		// imposta il valore di selezionato a true (a rappresentare che la scelta e' stata effettuata)
		selezionato = true;
	}
	
	public boolean estSelezionato(){
		return selezionato;
	}
}
