package attivita_io;

import java.util.Set;
import javax.swing.JOptionPane;

public class AttivitaIO {
	private static final String titolo = "Distributore souvenir";
	
	public static RecordTipoAcquisti chiediTipoSouvenir(){
		boolean berretti=false;
		boolean magneti=false;
		String[] scelte={"Magneti","Berretti","Magneti e Berretti"};
		String scelta=
			(String) JOptionPane.showInputDialog(null,"Che cosa si desidera comprare?",titolo,JOptionPane.QUESTION_MESSAGE,null,scelte,scelte[0]);
		if (scelta!=null)
		{
			berretti=scelta.contains("Berretti");
			magneti=scelta.contains("Magneti");
		}
		return(new RecordTipoAcquisti(magneti,berretti));
	}
	
	public static RecordAcquisto mostraSouvenirPerSelezione(Set<String> insiemeSouvenir)
	{
		SelezionaSouvenir selSouvenir=new SelezionaSouvenir(insiemeSouvenir);
		synchronized (selSouvenir){
			while(!selSouvenir.estSelezionato()){
				try {
					selSouvenir.wait();
				} catch (InterruptedException e) {
					e.printStackTrace();
					return(null);
				}
			}
		}
		selSouvenir.setVisible(false);
		return(selSouvenir.getAcquisto());
	}
	
	public static boolean altroMagnete()
	{
		int yn=JOptionPane.showConfirmDialog
		(null, "Si desidera comprare altri magneri?",titolo,JOptionPane.YES_NO_OPTION);
		return(yn==JOptionPane.YES_OPTION);
	}
	
	public static boolean altroBerretto()
	{
		int yn=JOptionPane.showConfirmDialog
		(null, "Si desidera comprare altri berretti?",titolo,JOptionPane.YES_NO_OPTION);
		return(yn==JOptionPane.YES_OPTION);
	}	
	
	public static void mostraScontrino(RecordScontrino record)
	{
		VisioneScontrino frame=new VisioneScontrino(record);
		synchronized (frame) 
		{
			try {
				frame.wait();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}
}
