package partecipaVerde;

import giocatore.*;

public final class ManagerPartecipaVerde {
	private ManagerPartecipaVerde(TipoLinkPartecipaVerde x) {
		link = x;
	}

	private TipoLinkPartecipaVerde link;

	public TipoLinkPartecipaVerde getLink() {
		return link;
	}

	public static void inserisci(TipoLinkPartecipaVerde y) {
		if (y != null && y.getGiocatore().quantiPartecipaVerde() == 0) {
			if (y.getGiocatore().getStato() != Giocatore.Stato.NONINGIOCO)
				throw new RuntimeException(
						"Non si puo' modificare un giocatore mentre sta giocando");
			ManagerPartecipaVerde k = new ManagerPartecipaVerde(y);
			y.getGiocatore().inserisciPerManagerPartecipaVerde(k);
			y.getPartita().inserisciPerManagerPartecipaVerde(k);
		}
	}

	public static void elimina(TipoLinkPartecipaVerde y) {
		if (y != null) {
			if (y.getGiocatore().getStato() != Giocatore.Stato.NONINGIOCO)
				throw new RuntimeException(
						"Non si puo' modificare un giocatore mentre sta giocando");
			ManagerPartecipaVerde k = new ManagerPartecipaVerde(y);
			y.getGiocatore().eliminaPerManagerPartecipaVerde(k);
			y.getPartita().eliminaPerManagerPartecipaVerde(k);
		}
	}
}
