package giocatoreBlu;

import partecipaBlu.*;
import giocatore.Giocatore;

public class GiocatoreBlu extends Giocatore {

private TipoLinkPartecipaBlu link = null;
	
	public GiocatoreBlu(String nome, int eta) {
		super(nome,eta);
	}

	public void inserisciLinkPartecipaBlu(TipoLinkPartecipaBlu t) {
		if (t != null && t.getGiocatore() == this)
			ManagerPartecipaBlu.inserisci(t);
	}

	public void eliminaLinkPartecipaBlu(TipoLinkPartecipaBlu t) {
		if (t != null && t.getGiocatore() == this)
			ManagerPartecipaBlu.elimina(t);
	}

	public TipoLinkPartecipaBlu getLinkPartecipaBlu() {
		return link;
	}

	public void inserisciPerManagerPartecipaBlu(ManagerPartecipaBlu a) {
		if (a != null)
			link = a.getLink();
	}

	public void eliminaPerManagerPartecipaBlu(ManagerPartecipaBlu a) {
		if (a != null)
			link = null;
	}

	public int quantiPartecipaBlu(){
		if (link == null)
			return 0;
		return 1;
	}
	
	public String toString(){
		return super.toString() + " (blu)";
	}

}
