package giocatore;

import _framework.*;
import _gestioneeventi.*;

public abstract class Giocatore implements Listener {
	private final String nome;
	private int eta;

	public Giocatore(String nome, int eta) {
		this.nome = nome;
		this.eta = eta; 
	}

	public String getNome() {
		return nome;
	}

	public int getEta() {
		return eta;
	}
	
	// gestione stato

	public static enum Stato {
		NONINGIOCO, INGIOCO
	}

	Stato statocorrente = Stato.NONINGIOCO;

	public Stato getStato() {
		return statocorrente;
	}

	public void fired(Evento e) {
		Executor.perform(new GiocatoreFired(this, e));
	}

	public String toString() {
		return nome;
	}
}
