package attivita_composte;

import giocatoreBlu.GiocatoreBlu;
import giocatoreVerde.GiocatoreVerde;

import attivita_io.*;

import partita.Partita;

import _framework.Executor;
import _gestioneeventi.EsecuzioneEnvironment;
import attivita_atomiche.*;

public class AttivitaPrincipale implements Runnable {

	private boolean eseguita = false;
	private Partita partita;
	private boolean altroGiocatore = false;

	public synchronized void run() {
		if (eseguita == true)
			return;
		eseguita = true;
		
		partita = AttivitaIO.LeggiDatiPartita();
		
		do{// Squadra blu
			GiocatoreBlu g = AttivitaIO.LeggiDatiGiocatoreBlu();
			
			altroGiocatore = (g != null);
			
			if(altroGiocatore){
				InserisciGiocatore inserisciGiocatore = new InserisciGiocatore(g,partita);
				Executor.perform(inserisciGiocatore);
			}
		}
		while(altroGiocatore);
		
		
		
		do{// Squadra verde
			GiocatoreVerde g = AttivitaIO.LeggiDatiGiocatoreVerde();
			
			altroGiocatore = (g != null);
			
			if(altroGiocatore){
				InserisciGiocatore inserisciGiocatore = new InserisciGiocatore(g,partita);
				Executor.perform(inserisciGiocatore);
			}
		}
		while(altroGiocatore);
		
	
		AvvioPartita avvioPartita = new AvvioPartita(partita);
		Executor.perform(avvioPartita);
		
		AttivitaSottoramo1 a1 = new AttivitaSottoramo1(partita);
		Thread ramo1 = new Thread(a1);
		ramo1.start();
		
			
		AttivitaAttendiFineMusica a2 = new AttivitaAttendiFineMusica();
		Thread ramo2 = new Thread(a2);
		ramo2.start();

		try {
			ramo1.join();
			ramo2.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}	
		
		EsecuzioneEnvironment.disattivaListener();
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
