package attivita_atomiche;

import eventi.InizioMusica;
import giocatoreBlu.GiocatoreBlu;
import giocatoreVerde.GiocatoreVerde;

import java.util.Iterator;

import partecipaBlu.TipoLinkPartecipaBlu;
import partecipaVerde.TipoLinkPartecipaVerde;
import partita.Partita;

import _framework.Executor;
import _framework.Task;
import _gestioneeventi.Environment;
import _gestioneeventi.EsecuzioneEnvironment;


public class AvvioPartita implements Task {

	private boolean eseguita = false;
	private Partita partita;

	public AvvioPartita(Partita partita) {
		this.partita = partita;
	}

	public synchronized void esegui(Executor e) {

		if (e == null || eseguita == true)
			return;
		eseguita = true;

		Iterator<TipoLinkPartecipaVerde> itg = partita.getLinkPartecipaVerde().iterator();
		while (itg.hasNext()) {
			GiocatoreVerde g = itg.next().getGiocatore();
			EsecuzioneEnvironment.addListener(g);
		}
		
		Iterator<TipoLinkPartecipaBlu> itr = partita.getLinkPartecipaBlu().iterator();
		while (itr.hasNext()) {
			GiocatoreBlu g = itr.next().getGiocatore();
			EsecuzioneEnvironment.addListener(g);
		}
		
		Environment.aggiungiEvento(new InizioMusica(null, null));
		EsecuzioneEnvironment.attivaListener();
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}