package partecipaVerde;

import partita.*;
import giocatoreVerde.*;

public class TipoLinkPartecipaVerde {
	private final GiocatoreVerde giocatore;
	private final Partita partita;

	public TipoLinkPartecipaVerde(GiocatoreVerde x, Partita y) {
		if (x == null || y == null) // CONTROLLO PRECONDIZIONI
			throw new RuntimeException(
					"Gli oggetti devono essere inizializzati");
		giocatore = x;
		partita = y;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkPartecipaVerde b = (TipoLinkPartecipaVerde) o;
			return b.giocatore == giocatore && b.partita == partita;
		} else
			return false;
	}

	public int hashCode() {
		return partita.hashCode() + giocatore.hashCode();
	}

	public Partita getPartita() {
		return partita;
	}

	public GiocatoreVerde getGiocatore() {
		return giocatore;
	}
}
