package attivita_atomiche;

import eventi.Passa;
import partita.Partita;
import partitaMulti.PartitaMulti;

import _framework.Executor;
import _framework.Task;
import _gestioneeventi.*;


public class Distribuzione implements Task {

	private boolean eseguita = false;
	private Partita partita;

	public Distribuzione(Partita partita) {
		this.partita = partita;
	}

	public synchronized void esegui(Executor e) {

		if (e == null || eseguita == true)
			return;
		eseguita = true;

		if (partita.getClass() == PartitaMulti.class){
			// in caso di partita multi-cerini, i cerini vengono distribuiti tra i giocatori blu
			
			PartitaMulti tm = (PartitaMulti)partita;
			int i;
			for (i = 0; i < tm.getNumeroCerini(); i++) {
				Environment.aggiungiEvento(new Passa(null, 
								partita.getLinkPartecipaBlu().get(i % partita.quantiGiocatoriBlu()).getGiocatore()));
			}			
		}
		else{ 
			// Altrimenti il (singolo) cerino viene dato ad un giocatore verde
			Environment.aggiungiEvento(new Passa(null, 
				partita.getLinkPartecipaVerde().get(0).getGiocatore()));
		}
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}


