package processo;

import _framework.*;
import gui.*;
import distributore.*;
import attivitaatomiche.*;

public class AttivitaSottoramoBevande implements Runnable {
	private boolean eseguita=false;
	private Scontrino scontrinoCorrente=null;
	private boolean ancoraBevande=true;
	private RecordAlimento alimentoSelezionato;
	
	public AttivitaSottoramoBevande(Scontrino scontrinoCorrente){
		this.scontrinoCorrente=scontrinoCorrente;
	}
		
	public synchronized void run() {
		if (eseguita)
			return;
		eseguita = true;
		
		while(ancoraBevande){
			LeggiBevande leggiBevande = new LeggiBevande();
			Executor.perform(leggiBevande);
			
			alimentoSelezionato = AttivitaIO.selezioneBevande(leggiBevande.getRisultato());
			
			AggiornaScontrino aggiornaScontrino = new AggiornaScontrino(alimentoSelezionato, scontrinoCorrente);
			Executor.perform(aggiornaScontrino);
			
			ancoraBevande = AttivitaIO.altraBevanda();
		}
	}
}
