package processo;

import distributore.*;
import gui.*;
import _framework.*;
import attivitaatomiche.*;

public class AttivitaPrincipale implements Runnable {
	private boolean eseguita=false;
	private Scontrino scontrinoCorrente=null;
	private RecordTipoAcquisti tipoAcquisti=null;
	
	public synchronized void run() {
		if (eseguita)
			return;
		eseguita = true;
		// Chiedi tipo alimenti
		tipoAcquisti=AttivitaIO.chiediTipoAlimenti();
		
		if (tipoAcquisti.isCibo() || tipoAcquisti.isBevande()){
			// S cibi o bevande
			CreaScontrino creaScontrino = new CreaScontrino();
			Executor.perform(creaScontrino);
			
			scontrinoCorrente = creaScontrino.getRisultato();
		
			Thread sottoRamoCibo = null;
			Thread sottoRamoBevande = null;

			if (tipoAcquisti.isCibo()){
				//s cibo
				sottoRamoCibo = new Thread(new AttivitaSottoramoCibo(scontrinoCorrente));				
				sottoRamoCibo.start();
			}
			
			if (tipoAcquisti.isBevande()){
				//s bevande
				sottoRamoBevande = new Thread(new AttivitaSottoramoBevande(scontrinoCorrente));				
				sottoRamoBevande.start();
			}
			
			//join
			try{
				if (sottoRamoCibo != null){
					sottoRamoCibo.join();
				}
				if (sottoRamoBevande != null){
					sottoRamoBevande.join();
				}
			}
			catch (InterruptedException e){
				e.printStackTrace();
				System.exit(1);
			}			
			
			LeggiScontrino leggiScontrino = new LeggiScontrino(scontrinoCorrente);
			Executor.perform(leggiScontrino);
			
			AttivitaIO.mostraScontrino(leggiScontrino.getRisultato());
			
		}// s cibi o bevande
	}
}
