package gui;

import java.util.*;

public class RecordScontrino 
{
	//Numero dello scontrino
	private final int numero;
	// Data di emissione dello scontrino
	private final Date emissione;
	// totale spesa
	private final float totale;
	// Insieme di RecordAlimento (coppie nome-quantita'), contenente tutti gli alimenti compresi nello scontrino, con le relative quantita
	private final HashSet<RecordAlimento> insieme=new HashSet<RecordAlimento>();

	public RecordScontrino(int numero,Date emissione,float totale)
	{
		this.numero=numero;
		this.emissione=emissione;
		this.totale=totale;
	}
	
	public void addRecord(RecordAlimento ra)
	{// Aggiunge RecordAlimento ra 
		insieme.add(ra);
	}
	
	public int getNumero() {
		return numero;
	}

	public Date getEmissione() {
		return emissione;
	}

	@SuppressWarnings("unchecked")
	public Set<RecordAlimento> getInsiemeRecord() {
		return (Set<RecordAlimento>)insieme.clone();
	}

	public float getTotale() {
		return totale;
	}
}
