package gui;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

import distributore.*;

public class Modello 
{
	private static HashMap<String,Alimento> listaAlimenti=new HashMap<String, Alimento>();
	private static HashMap<Integer,Scontrino> listaScontrini=new HashMap<Integer,Scontrino>();
	
	public static boolean aggiungiAlimento(Alimento alimento)
	{// Aggiunge un alimento, se non ne  presente gi uno con stesso nome
		if (!listaAlimenti.containsKey(alimento.getNome()))
		{
			listaAlimenti.put(alimento.getNome(), alimento);
			return(true);
		}
		else
			return(false);
	}
	
	public static Alimento getAlimentoDaNome(String nomeAlimento){
		// Restituisce l'alimento a partire dal nome (non possono esistere duplicati)
		return listaAlimenti.get(nomeAlimento);
	}

	public static Collection<Alimento> listaAlimenti()
	{
		return(Collections.unmodifiableCollection(listaAlimenti.values()));
	}
	

	
	public static boolean aggiungiScontrino(Scontrino scontr)
	{// Aggiunge uno scontrino, se non ne  presente gi uno con stesso numero
		if (!listaScontrini.containsKey(scontr.getNumero()))
		{
			listaScontrini.put(scontr.getNumero(), scontr);
			return(true);
		}
		else
			return(false);
	}
	
	public static Collection<Scontrino> listaScontrini()
	{
		return(Collections.unmodifiableCollection(listaScontrini.values()));
	}	
}
