package gui;

import java.util.Set;

import javax.swing.JOptionPane;

public class AttivitaIO 
{
	public static RecordTipoAcquisti chiediTipoAlimenti()
	{
		boolean bevande=false;
		boolean cibi=false;
		String[] scelte={"Cibi","Bevande","Cibi e Bevande"};
		String scelta=
			(String) JOptionPane.showInputDialog(null,"Che cosa si desidera comprare?","Distributore automatico",JOptionPane.QUESTION_MESSAGE,null,scelte,scelte[0]);
		if (scelta!=null)
		{
			bevande=scelta.contains("Bevande");
			cibi=scelta.contains("Cibi");
		}
		return(new RecordTipoAcquisti(cibi,bevande));
	}
	
	public static RecordAlimento selezioneCibo(Set<String> listaAlimenti)
	{
		SelezionaAlimento alim=new SelezionaAlimento(listaAlimenti);
		synchronized (alim) 
		{
			try {
				alim.wait();
			} catch (InterruptedException e) {
				e.printStackTrace();
				return(null);
			}
		}
		alim.setVisible(false);
		return(alim.getRecord());
	}
	
	public static RecordAlimento selezioneBevande(Set<String> listaAlimenti) 
	{
		return(selezioneCibo(listaAlimenti));
	}
	
	public static boolean altroCibo()
	{
		int yn=JOptionPane.showConfirmDialog
		(null, "Si desidera comprare altro cibo?","Distributore automatico",JOptionPane.YES_NO_OPTION);
		return(yn==JOptionPane.YES_OPTION);
	}
	
	public static boolean altraBevanda()
	{
		int yn=JOptionPane.showConfirmDialog
		(null, "Si desidera comprare un'altra bevanda?","Distributore automatico",JOptionPane.YES_NO_OPTION);
		return(yn==JOptionPane.YES_OPTION);
	}	
	
	public static void mostraScontrino(RecordScontrino record)
	{
		VisioneScontrino frame=new VisioneScontrino(record);
		synchronized (frame) 
		{
			try {
				frame.wait();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}
}
