package distributore;

public class TipoLinkComprende
{
	private final Alimento alimento;
	private final Scontrino scontrino;
	private final int quantita;
	
	public TipoLinkComprende(Alimento alimento, Scontrino scontrino, int quantita) throws EccezionePrecondizioni
	{
		if (alimento==null || scontrino==null)
			throw(new EccezionePrecondizioni("Impossibile passare dei valori nulli"));
		if (quantita<=0)
			throw(new EccezionePrecondizioni("La quantit deve essere un valore positivo"));			
		this.alimento=alimento;
		this.scontrino=scontrino;
		this.quantita=quantita;
	}
	
	public Alimento getAlimento() {
		return alimento;
	}
	public Scontrino getScontrino() {
		return scontrino;
	}

	public int hashCode() 
	{
		return alimento.hashCode()+scontrino.hashCode();
	}
	
	public int getQuantita()
	{
		return quantita;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TipoLinkComprende other = (TipoLinkComprende) obj;
		if (!alimento.equals(other.alimento))
			return false;
		if (!scontrino.equals(other.scontrino))
			return false;
		return true;
	}
	
	
}
