package attivitaatomiche;

import java.util.*;

import distributore.*;
import _framework.*;
import gui.*;

public class LeggiScontrino implements Task {
	private boolean eseguita = false;
	private RecordScontrino recordScontrino;
	private Scontrino scontrino;
 	
	public LeggiScontrino(Scontrino scontrinoCorrente){
		scontrino = scontrinoCorrente;
	}
	
	public synchronized void esegui(Executor e) {
		if ( eseguita || e == null)
			return;
		eseguita = true;
		/* Accede allo scontrino corrente e costruisce il relativo 
		 * recordScontrino, contenente la lista degli alimenti acquistati 
		 * e la spesa totale
		 */
		recordScontrino = new RecordScontrino(scontrino.getNumero(), scontrino.getData(), scontrino.totale());
		Set<TipoLinkComprende> alimentiAcquistati = scontrino.getLinkComprende();
		Iterator<TipoLinkComprende> alimentiIt = alimentiAcquistati.iterator();
		while (alimentiIt.hasNext()){
			TipoLinkComprende linkCorrente = alimentiIt.next();
			// Crea il RecordAlimento associato all'alimento corrente e lo inserisce in recordScontrino					
			recordScontrino.addRecord(new RecordAlimento(linkCorrente.getAlimento().getNome(), linkCorrente.getQuantita()));
		}
	}
	
	public RecordScontrino getRisultato(){
		return recordScontrino;
	}
}
