package gui;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.util.*;

import javax.swing.*;

import distributore.Alimento;

public class SelezionaAlimento extends JFrame 
{
	private final JComboBox alimentiCbx;
	private final JLabel alimentiLbl=new JLabel("Alimenti:");
	private final JPanel alimentiPnl=new JPanel();
	private final JLabel quantitaLbl=new JLabel("Quantita':");
	private final JTextField quantitaTxt=new JTextField(2);
	private final JButton okBtn = new JButton("OK");
	private final JPanel centroPnl=new JPanel(new GridLayout(2,1));
	private final JPanel quantitaPnl=new JPanel();
	private final JPanel sudPnl=new JPanel();
	
	public SelezionaAlimento(Collection<String> e)
	{
		super("Seleziona Alimento");
		alimentiCbx=new JComboBox(new Vector<String>(e));
		alimentiPnl.add(alimentiLbl);
		alimentiPnl.add(alimentiCbx);
		centroPnl.add(alimentiPnl);
		quantitaPnl.add(quantitaLbl);
		quantitaPnl.add(quantitaTxt);
		centroPnl.add(quantitaPnl);
		sudPnl.add(okBtn);
		okBtn.addActionListener(new SelezionaAlimentoListener(this));
		getContentPane().add(centroPnl,BorderLayout.CENTER);
		getContentPane().add(sudPnl,BorderLayout.SOUTH);
		setSize(200,150);
		setVisible(true);
	}
	
	public RecordAlimento getRecord() throws NumberFormatException
	{
		String alim = (String) alimentiCbx.getSelectedItem();
		return (new RecordAlimento(alim, Integer
				.parseInt(quantitaTxt.getText())));

	}

}
