package attivitaatomiche;

import java.util.*;
import _framework.*;
import distributore.*;
import gui.*;


public class AggiornaScontrino implements Task {
	private boolean eseguita=false;
	private Scontrino scontrinoCorrente;
	private RecordAlimento recordAlimento;
	
	public AggiornaScontrino(RecordAlimento recordAlimento, Scontrino scontrino){
		this.scontrinoCorrente = scontrino;
		this.recordAlimento = recordAlimento;
	}
	
	public synchronized void esegui(Executor e) {
		if (eseguita || e==null)
			return;
		eseguita = true;
		// A partire dal nome dell'alimento, ottiene un riferimento all'oggetto di tipo Alimento con quel nome
		Alimento alimentoAcquistato = Modello.getAlimentoDaNome(recordAlimento.getNome());
		try{
			TipoLinkComprende nuovoLink = new TipoLinkComprende(alimentoAcquistato, scontrinoCorrente, recordAlimento.getQuantita());
			
			// Se e' gia' presente un link comprende tra scontrinoCorrente ed alimentoAcquistato, deve essere rimpiazzato da un link analogo
			// con quantita' pari a quella del link presente pi la quantita' di alimento acquistata 
			
			if (scontrinoCorrente.getLinkComprende().contains(nuovoLink)){
				Iterator<TipoLinkComprende> linkIt = scontrinoCorrente.getLinkComprende().iterator();
				TipoLinkComprende linkPresente=null;
				do{// Scorre l'insieme dei link fino a trovare il link gia' presente uguale a quello da inserire 
				// NOTA: le quantita' non sono rilevanti per equals()
					linkPresente = linkIt.next();
				}
				while(!linkPresente.equals(nuovoLink));
				
				//Rimpiazza il link gia' presente con quello nuovo
				scontrinoCorrente.eliminaLinkComprende(linkPresente);
				scontrinoCorrente.inserisciLinkComprende(new TipoLinkComprende(alimentoAcquistato, scontrinoCorrente, recordAlimento.getQuantita()+linkPresente.getQuantita()));
			}
			else{
				//Altrimenti inerisce il nuovo link
				scontrinoCorrente.inserisciLinkComprende(nuovoLink);
			}
		}
		catch( EccezionePrecondizioni ecc){
			ecc.printStackTrace();
			System.exit(1);
		}
	}
}



