package processo;

import officina.Riparazione;

public class AttivitaRichiestaPersonale implements Runnable {
	private boolean eseguita=false;
	private Riparazione pratica;

	public AttivitaRichiestaPersonale(Riparazione pratica){
		this.pratica = pratica;
	}
	
public synchronized void run() {
		if (eseguita)
				return;
		eseguita = true;
		// devo eseguire i vari rami della sotto-attivit
		Thread sottoramoInvia = new Thread(new SottoramoInviaRichiesta(pratica));
		Thread sottoramoLeggiRichiesta = new Thread(new SottoramoLeggiRichiesta(pratica));			
		
		sottoramoInvia.start();			
		sottoramoLeggiRichiesta.start();
		
		try {
			sottoramoInvia.join();			
			sottoramoLeggiRichiesta.join();
		}
		catch (InterruptedException e) {
			e.printStackTrace();
			System.exit(1);
		}			
	}
}
