package officina;

public class TipoLinkCoinvolto
{
	private final Riparazione riparazione;
	private final Veicolo veicolo;
	
	public TipoLinkCoinvolto(Riparazione riparazione, Veicolo veicolo) throws EccezionePrecondizioni
	{
		if (riparazione==null || veicolo==null)
			throw(new EccezionePrecondizioni("Impossibile passare dei valori nulli"));
		this.riparazione=riparazione;
		this.veicolo=veicolo;
	}
	
	public Riparazione getRiparazione() {
		return riparazione;
	}
	public Veicolo getVeicolo() {
		return veicolo;
	}

	public int hashCode() 
	{
		return riparazione.hashCode()+veicolo.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TipoLinkCoinvolto other = (TipoLinkCoinvolto) obj;
		if (!riparazione.equals(other.riparazione))
			return false;
		if (!veicolo.equals(other.veicolo))
			return false;
		return true;
	}
	
	
}
