package processoquotazioneborsa;

import azienda.*;

public class VerificaSoglia implements Runnable {

	private boolean eseguita = false;
	private Azienda azienda;
	private boolean result;

	public VerificaSoglia(Azienda a) {
		this.azienda = a;
	}

	public synchronized void run() {
		if (eseguita == true)
			return;
		eseguita = true;
		
		Sottoramo1 ramo1 = new Sottoramo1(azienda);
		Sottoramo2 ramo2 = new Sottoramo2();
		
		Thread thread_ramo1 = new Thread(ramo1);
		thread_ramo1.start();
		Thread thread_ramo2 = new Thread(ramo2);
		thread_ramo2.start();
		
		try {
			thread_ramo1.join();
			thread_ramo2.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
		
		if (ramo1.getResult() <= ramo2.getResult())
			result = true;
		else result = false;
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

	public synchronized boolean getResult() {
		if (eseguita == true)
			return this.result;
		else
			throw new RuntimeException(
					"ERRORE: non è disponibile il risultato su un'attività non eseguita");
	}
}
