package processoquotazioneborsa;

import java.util.*;

import attivitaatomiche.*;
import attivitaio.*;
import _framework.*;
import azienda.*;

public class ProcessoQuotazioneBorsa implements Runnable {

	private boolean eseguita;

	public synchronized void run() {

		if (eseguita == true)
			return;
		eseguita = true;

		Azienda azienda = AttivitaIO.LeggiAzienda();

		ControlloControllanteControllate ccc = new ControlloControllanteControllate(
				azienda);
		Executor.perform(ccc);

		if (ccc.getResult() == true) {
			VerificaSoglia vs = new VerificaSoglia(azienda);
			Thread vs_thread = new Thread(vs);
			vs_thread.start();
			try {
				vs_thread.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			if (vs.getResult() == true) {
				Executor.perform(new ConcessioneAutorizzazione(azienda));
			} else {
				AttivitaIO.StampaRifiuto(azienda);

			}
		} else {
			RecuperaControllate rc = new RecuperaControllate(azienda);
			Executor.perform(rc);

			HashSet<Thread> threads = new HashSet<Thread>();
			HashSet<VerificaSoglia> activities = new HashSet<VerificaSoglia>();

			Iterator<Azienda> current = rc.getResult().iterator();
			Iterator<Thread> currentThread;
			Iterator<VerificaSoglia> currentActivity;

			while (current.hasNext()) {
				VerificaSoglia auxActivity = new VerificaSoglia(current.next());
				activities.add(auxActivity);

				Thread auxThread = new Thread(auxActivity);
				threads.add(auxThread);
				auxThread.start();
				
			}

			currentThread = threads.iterator();
			while (currentThread.hasNext()) {
				try {
					currentThread.next().join();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}

			int ok = 0;
			int ko = 0;

			currentActivity = activities.iterator();
			while (currentActivity.hasNext()) {
				if (currentActivity.next().getResult() == true)
					ok += 1;
				else
					ko += 1;
			}
			
			System.out.println("OK: " + ok + " e KO: " + ko);

			if (ok >= ko)
				Executor.perform(new ConcessioneAutorizzazione(azienda));
			else
				AttivitaIO.StampaRifiuto(azienda);
		}
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
