package localita;

import java.util.*;
import averesede.*;

public class Localita {
	private String nome;
	private HashSet<TipoLinkAvereSede> aziende;
	
	public Localita(String nome) {
		this.nome = nome;
		this.aziende = new HashSet<TipoLinkAvereSede>();
	}

	public String getNome() {
		return nome;
	}

	// metodi per la gestione dell'associazione "avere sede"
	// tra Azienda e Località
	public void inserisciLinkAvereSede(TipoLinkAvereSede t) {
		if (t != null && t.getLocalità() == this)
			ManagerAvereSede.inserisci(t);
	}

	public void eliminaLinkAvereSede(TipoLinkAvereSede t) {
		if (t != null && t.getLocalità() == this)
			ManagerAvereSede.elimina(t);
	}
	
	@SuppressWarnings("unchecked")
	public Set<TipoLinkAvereSede> getLinkAvereSede() {
		return (Set<TipoLinkAvereSede>) this.aziende.clone();
	}

	public void inserisciPerManagerAvereSede(ManagerAvereSede a) {
		if (a != null)
			this.aziende.add(a.getLink());
	}

	public void eliminaPerManagerAvereSede(ManagerAvereSede a) {
		if (a != null)
			this.aziende.remove(a.getLink());
	}
	
}
