package controllare;

import azienda.*;

public class TipoLinkControllare {

	private final Azienda controllata;
	private final Azienda controllante;

	public TipoLinkControllare(Azienda controllante, Azienda controllata)
			throws RuntimeException {
		if (controllante == null || controllata == null) 	// CONTROLLO
															// PRECONDIZIONI
			throw new RuntimeException(
					"Gli oggetti devono essere inizializzati");
		this.controllante = controllante;
		this.controllata = controllata;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkControllare b = (TipoLinkControllare) o;
			return b.controllata == this.controllata
					&& b.controllante == this.controllante;
		} else
			return false;
	}

	public int hashCode() {
		return this.controllante.hashCode() + this.controllata.hashCode();
	}

	public Azienda getControllante() {
		return this.controllante;
	}

	public Azienda getControllata() {
		return this.controllata;
	}
}