package azienda;

import java.util.*;

import controllare.*;
import averesede.*;

public abstract class Azienda {

	private final int MOLT_MIN_SEDI = 1;
	private String nome;
	private String descrizione;
	private boolean quotata;
	private java.util.GregorianCalendar dataQuotazioneBorsa;

	private HashSet<TipoLinkAvereSede> sedi;
	private HashSet<TipoLinkControllare> controllate;
	private TipoLinkControllare controllante;

	protected Azienda(String nome, String descrizione) {
		this.nome = nome;
		this.descrizione = descrizione;
		this.quotata = false;
		this.dataQuotazioneBorsa = null;
		this.controllate = new HashSet<TipoLinkControllare>();
		this.controllante = null;
		this.sedi = new HashSet<TipoLinkAvereSede>();
	}

	public String getNome() {
		return this.nome;
	}

	public String getDescrizione() {
		return this.descrizione;
	}

	public boolean isQuotata() {
		return this.quotata;
	}

	public java.util.GregorianCalendar getDataQuotazioneBorsa() {
		return this.dataQuotazioneBorsa;
	}

	public void setQuotazioneInBorsa(java.util.GregorianCalendar data) {
		if (data != null) {
			this.quotata = true;
			this.dataQuotazioneBorsa = data;
		}
	}

	// metodi per la gestione dell'associazione "avere sede"
	// tra Azienda e Località
	public void inserisciLinkAvereSede(TipoLinkAvereSede t) {
		if (t != null && t.getAzienda() == this)
			ManagerAvereSede.inserisci(t);
	}

	public void eliminaLinkAvereSede(TipoLinkAvereSede t) {
		if (t != null && t.getAzienda() == this)
			ManagerAvereSede.elimina(t);
	}
	
	public int quanteSedi() {
		return this.sedi.size();
	}

	@SuppressWarnings("unchecked")
	public Set<TipoLinkAvereSede> getLinkAvereSede() {
		if (this.sedi.size() < MOLT_MIN_SEDI)
			throw new RuntimeException("Molteplicità minima violata");
		return (Set<TipoLinkAvereSede>) this.sedi.clone();
	}

	public void inserisciPerManagerAvereSede(ManagerAvereSede a) {
		if (a != null)
			this.sedi.add(a.getLink());
	}

	public void eliminaPerManagerAvereSede(ManagerAvereSede a) {
		if (a != null)
			this.sedi.remove(a.getLink());
	}
		
	// metodi per la gestione dell'associazione "controllare"
	// tra Azienda controllante ed Azienda controllata
	public void inserisciLinkControllare(TipoLinkControllare t) {
		if (t != null && t.getControllante() == this)
			ManagerControllare.inserisci(t);
	}

	public void eliminaLinkControllare(TipoLinkControllare t) {
		if (t != null && t.getControllante() == this)
			ManagerControllare.elimina(t);
	}

	@SuppressWarnings("unchecked")
	public Set<TipoLinkControllare> getLinkControllate() {
		return (Set<TipoLinkControllare>) this.controllate.clone();
	}

	public void inserisciPerManagerControllare(ManagerControllare a) {
		if (a != null)
			this.controllate.add(a.getLink());
	}

	public void eliminaPerManagerControllare(ManagerControllare a) {
		if (a != null)
			this.controllate.remove(a.getLink());
	}

	// metodi per la gestione dell'associazione "controllare"
	// tra Azienda controllata ed Azienda controllante
	public void inserisciLinkControllata(TipoLinkControllare t) {
		if (t != null && t.getControllata() == this)
			ManagerControllare.inserisci(t);
	}

	public void eliminaLinkControllata(TipoLinkControllare t) {
		if (t != null && t.getControllante() == this)
			ManagerControllare.elimina(t);
	}

	public TipoLinkControllare getLinkControllata() {
		return this.controllante;
	}

	public void inserisciPerManagerControllata(ManagerControllare a) {
		if (a != null)
			this.controllante = a.getLink();
	}

	public void eliminaPerManagerControllata(ManagerControllare a) {
		if (a != null)
			this.controllante = null;
	}
}
