package averesede;

import azienda.*;
import localita.*;

public class TipoLinkAvereSede {

	private final Azienda lAzienda;
	private final Localita laLocalità;

	public TipoLinkAvereSede(Azienda a, Localita l)
			throws RuntimeException {
		if (a == null || l == null) 	// CONTROLLO
										// PRECONDIZIONI
			throw new RuntimeException(
					"Gli oggetti devono essere inizializzati");
		this.lAzienda = a;
		this.laLocalità = l;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkAvereSede b = (TipoLinkAvereSede) o;
			return b.lAzienda == this.lAzienda
					&& b.laLocalità == this.laLocalità;
		} else
			return false;
	}

	public int hashCode() {
		return this.laLocalità.hashCode() + this.lAzienda.hashCode();
	}

	public Azienda getAzienda() {
		return this.lAzienda;
	}

	public Localita getLocalità() {
		return this.laLocalità;
	}
}