package attivitaatomiche;

import java.util.*;
import azienda.*;
import controllare.*;
import _framework.*;

public class RecuperaControllate implements Task {

	private boolean eseguita = false;
	private Azienda azienda;
	private static Set<Azienda> result;

	public RecuperaControllate(Azienda a) {
		this.azienda = a;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;

		result = new HashSet<Azienda>();
		
		Iterator<TipoLinkControllare> it = this.azienda.getLinkControllate().iterator();
		while (it.hasNext()) {
			Azienda controllata = it.next().getControllata();
			result.add(controllata);
			aggiungiControllate(controllata);
		}
		
		// per controllare la correttezza del risultato
		Iterator<Azienda> aux = result.iterator();
		while (aux.hasNext()) 
			System.out.println(aux.next());
	}

	private static void aggiungiControllate(Azienda a){
		
		// si suppone che non possano esistere cicli controllante/controllate
		Iterator<TipoLinkControllare> it = a.getLinkControllate().iterator();
		while (it.hasNext()) {
			Azienda controllata = it.next().getControllata();
			result.add(controllata);
			aggiungiControllate(controllata);
		}	
	}		
	
	public synchronized boolean estEseguita() {
		return eseguita;
	}
	
	public synchronized Set<Azienda> getResult() {
		if (eseguita == true)
			return result;
		else
			throw new RuntimeException(
					"ERRORE: non è disponibile il risultato su un'attività non eseguita");
	}
}
