package attivitaatomiche;

import java.util.GregorianCalendar;

import attivitaio.*;
import _framework.*;
import azienda.*;

public class ConcessioneAutorizzazione implements Task {

	private boolean eseguita = false;
	private Azienda azienda;

	public ConcessioneAutorizzazione(Azienda a) {
		this.azienda = a;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;

		azienda.setQuotazioneInBorsa(new GregorianCalendar());
		AttivitaIO.StampaAutorizzazione(azienda);
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
