package attivitaatomiche;

import java.util.*;
import azienda.*;
import averesede.*;
import localita.*;
import _framework.*;

public class Calcolo implements Task {

	private boolean eseguita = false;
	private Azienda azienda;
	private int result;

	public Calcolo(Azienda a) {
		this.azienda = a;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;
		
		result = 0;
		int numeroLocalità = 0;

		Iterator<TipoLinkAvereSede> it = this.azienda.getLinkAvereSede().iterator();
		while (it.hasNext()) {
			numeroLocalità += 1;
			Localita loc = it.next().getLocalità();
			Iterator<TipoLinkAvereSede> az = loc.getLinkAvereSede().iterator();
			while (az.hasNext()){
				if (az.next().getAzienda().isQuotata() == true)
				result += 1;
			}
			
		}
		if (result != 0 && numeroLocalità != 0)
			result = result / numeroLocalità; 		
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

	public synchronized int getResult() {
		if (eseguita == true)
			return result;
		else
			throw new RuntimeException(
					"ERRORE: non è disponibile il risultato su un'attività non eseguita");
	}

}