package applicazione;

import processoquotazioneborsa.*;
import aziendapubblica.*;
import aziendaprivata.*;
import ente.*;
import localita.*;
import attivitaio.AttivitaIO;
import averesede.*;
import controllare.*;

public class Main {

	public static void main(String[] args) {
		
		// Crea un insieme iniziale di oggetti su cui opera il processo
		Localita l1 = new Localita("Roma");
		Localita l2 = new Localita("Milano");
				
		AziendaPubblica a = new AziendaPubblica("Pubblica A", "azienda pubblica a @ Roma");
		a.setGestore(new Ente("Ente 1", "1"));
		a.inserisciLinkAvereSede(new TipoLinkAvereSede(a, l1));
		
		AziendaPubblica b = new AziendaPubblica("Pubblica B", "azienda pubblica b @ Milano");
		b.setGestore(new Ente("Ente 2", "2"));
		b.inserisciLinkAvereSede(new TipoLinkAvereSede(b, l2));
		
		AziendaPrivata c = new AziendaPrivata("Privata C", "azienda privata c @ Roma", 1000);
		c.inserisciLinkAvereSede(new TipoLinkAvereSede(c, l1));
		c.setQuotazioneInBorsa(new java.util.GregorianCalendar());
		
		AziendaPrivata d = new AziendaPrivata("Privata D", "azienda privata d @ Roma", 2000);
		d.inserisciLinkAvereSede(new TipoLinkAvereSede(d, l1));
		d.setQuotazioneInBorsa(new java.util.GregorianCalendar());
		AziendaPrivata e = new AziendaPrivata("Privata E", "azienda privata e @ Milano", 3000);
		e.inserisciLinkAvereSede(new TipoLinkAvereSede(e, l2));
		
		a.inserisciLinkControllare(new TipoLinkControllare(a,b));
		a.inserisciLinkControllare(new TipoLinkControllare(a,c));
		b.inserisciLinkControllare(new TipoLinkControllare(b,d));
		e.inserisciLinkControllata(new TipoLinkControllare(d,e));
		
		// artificio per simulare la lettura dell'azienda su cui opera il processo
		AttivitaIO.aziendaDaLeggere = a;
				
		// avvio del processo
		new Thread(new ProcessoQuotazioneBorsa()).start();
	}
}
