package processo;

import gui.Attesa;
import gui.AttivitaIO;
import gui.RecordPratica;
import _framework.*;
import officina.*;

public class AttivitaPrincipale implements Runnable
{
	private boolean eseguita=false;
	private Riparazione pratica;
	
	public AttivitaPrincipale(Veicolo veicolo) throws EccezionePrecondizioni
	{
		pratica=new Riparazione();
		TipoLinkCoinvolto tl=new TipoLinkCoinvolto(pratica,veicolo);
		ManagerCoinvolto.inserisci(tl);
	}
	
	public synchronized Riparazione getRis()
	{
		if (!eseguita)
			throw(new RuntimeException());
		else
			return(pratica);
	}
	
	public synchronized void run() {
		if (eseguita)
			return;
		eseguita=true;
		AttivitaIO.aspetta(new Attesa<Riparazione>("Inserisci dati riparazione",pratica));
		RecordPratica record=AttivitaIO.leggiDatiPratica(pratica);
		ApriPratica ap=new ApriPratica(pratica,record);
		Executor.perform(ap);
		do
		{
			AttivitaIO.aspetta(new Attesa<Riparazione>("Inserisci Valutazione Danni",pratica));			
			record=AttivitaIO.leggiValutazioneDanni(pratica);
			Executor.perform(new EffettuaValutazione(pratica,record));
			Executor.perform(new AcquistaPezzi(pratica));
			
			Thread sottoramoPersonale = new Thread(new SottoramoPersonale(pratica));
			Thread sottoramoMeccanica=null;
			Thread sottoramoCarrozzeria=null;

			sottoramoPersonale.start();
			if (pratica.isMeccanicaDanneggiata())
			{
				sottoramoMeccanica=new Thread(new SottoramoMeccanica(pratica));
				sottoramoMeccanica.start();
			}
			if (pratica.isCarrozzeriaDanneggiata())
			{
				sottoramoCarrozzeria=new Thread(new SottoramoCarrozzeria(pratica));
				sottoramoCarrozzeria.start();
			}
			try {
				sottoramoPersonale.join();
				if (sottoramoMeccanica != null)
					sottoramoMeccanica.join();
				if (sottoramoCarrozzeria != null)
					sottoramoCarrozzeria.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
				System.exit(1);
			}
		} while(pratica.isCarrozzeriaDanneggiata() || pratica.isMeccanicaDanneggiata());
	}

}
