package gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import officina.EccezionePrecondizioni;
import officina.Veicolo;

import processo.AttivitaPrincipale;
import processo.Modello;

public class FinestraPrincipaleListener implements ActionListener 
{

	public static final String INSERISCI_VEICOLO = "I";
	public static final String NUOVA_PRATICA = "N";
	public static final String LISTA_ATTESA = "L";
	private FinestraPrincipale frame;

	public FinestraPrincipaleListener(FinestraPrincipale finestraPrincipale) {
		this.frame=finestraPrincipale;
	}

	
	public void actionPerformed(ActionEvent ae) 
	{
		String com=ae.getActionCommand();
		
		if (com==INSERISCI_VEICOLO)
			inserisciVeicolo();
		else if (com==NUOVA_PRATICA)
			nuovaPratica();
		else if (com==LISTA_ATTESA)
			listaAttesa();
			

	}


	private void listaAttesa() 
	{
		new ListaAttesaFrame();
	}


	private void nuovaPratica() 
	{
		try {
			Veicolo[] veicoli=Modello.listaVeicoli();
			Veicolo v=(Veicolo) JOptionPane.showInputDialog(null,"Selezionare il veicolo","Inizio nuova riparazione",
					JOptionPane.INFORMATION_MESSAGE,null,veicoli,veicoli[0]);
			if (v==null)
				return;
			//v E' IL VEICOLO SELEZIONATO
			//DA COMPLETARE A CURA DELLO STUDENTE
		} 
		catch (ArrayIndexOutOfBoundsException e)
		{
			JOptionPane.showMessageDialog(frame, "Nessun veicolo inserito");
		}
	}


	private void inserisciVeicolo() 
	{
		new InserimentoVeicoli();
	}

}
