package processo;

import gui.AttivitaIO;
import gui.RecordPratica;
import _framework.*;
import officina.*;

public class AttivitaPrincipale implements Runnable
{
	private boolean eseguita=false;
	private Riparazione pratica;
	
	public AttivitaPrincipale(Veicolo veicolo) throws EccezionePrecondizioni
	{
		pratica=new Riparazione();
		TipoLinkCoinvolto tl=new TipoLinkCoinvolto(pratica,veicolo);
		ManagerCoinvolto.inserisci(tl);
	}
	
	public synchronized Riparazione getRis()
	{
		if (!eseguita)
			throw(new RuntimeException());
		else
			return(pratica);
	}
	
	public synchronized void run() {
		if (eseguita)
			return;
		eseguita=true;
		RecordPratica record=AttivitaIO.leggiDatiPratica(pratica);
		ApriPratica ap=new ApriPratica(pratica,record);
		Executor.perform(ap);
		do
		{
			record=AttivitaIO.leggiValutazioneDanni(pratica);
			Executor.perform(new EffettuaValutazione(pratica,record));
			Executor.perform(new AcquistaPezzi(pratica));
			Thread ramo1=null;
			Thread ramo2=null;
			if (pratica.isMeccanicaDanneggiata())
			{
				ramo1=new Thread(new AttivitaRipMeccanica(pratica));
				ramo1.start();
			}
			if (pratica.isCarrozzeriaDanneggiata())
			{
				ramo2=new Thread(new AttivitaRipCarrozzeria(pratica));
				ramo2.start();
			}
			try {
				if (ramo1 != null)
					ramo1.join();
				if (ramo2 != null)
					ramo2.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
				System.exit(1);
			}
		} while(pratica.isCarrozzeriaDanneggiata() || pratica.isMeccanicaDanneggiata());
	}

}
